<?php
require_once __DIR__ . '/vendor/autoload.php';

// Manually include the PhpAmqpLib library
require_once __DIR__ . '/vendor/php-amqplib/php-amqplib/PhpAmqpLib/Connection/AMQPStreamConnection.php';
require_once __DIR__ . '/vendor/php-amqplib/php-amqplib/PhpAmqpLib/Message/AMQPMessage.php';

use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Message\AMQPMessage;

// Connect to RabbitMQ server
$connection = new AMQPStreamConnection('localhost', 5672, 'guest', 'guest');
$channel = $connection->channel();

// Declare the queue and exchange
$queueName = 'my_queue';
$exchangeName = 'my_message_exchange';
$channel->queue_declare($queueName, false, true, false, false);
$channel->exchange_declare($exchangeName, 'direct', false, true, false);
$channel->queue_bind($queueName, $exchangeName);

// Generate a unique identifier for the message
$uniqueId = uniqid();

// Create the message with the unique identifier
$messageBody = 'Message with unique identifier: ' . $uniqueId;
$message = new AMQPMessage($messageBody, ['delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT]);

// Publish the message on the exchange
$channel->basic_publish($message, $exchangeName);

// Confirm that the message was delivered successfully
$channel->wait_for_pending_acks_returns();

echo "Message delivered successfully. Unique identifier: $uniqueId\n";

// Close the connection
$channel->close();
$connection->close();
