<?php

// Interface for Command
interface Command
{
    public function execute();
    public function undo();
}

// Concrete Command to add an item to the queue
class AddItemCommand implements Command
{
    private $queue;
    private $item;

    public function __construct(&$queue, $item)
    {
        $this->queue = &$queue;
        $this->item = $item;
    }

    public function execute()
    {
        array_push($this->queue, $this->item);
        echo "Item '{$this->item}' added to the queue.<br />";
    }

    public function undo()
    {
        $removedItem = array_pop($this->queue);
        echo "Item '{$removedItem}' removed from the queue.<br />";
    }
}

// Invoker
class CommandQueue
{
    private $commands = [];
    private $undoneCommands = [];

    public function addCommand(Command $command)
    {
        $this->commands[] = $command;
    }

    public function processCommands()
    {
        foreach ($this->commands as $command)
        {
            $command->execute();
        }
        $this->commands = [];
    }

    public function undoLastCommand()
    {
        if (!empty($this->commands))
        {
            $lastCommand = array_pop($this->commands);
            $lastCommand->undo();
            $this->undoneCommands[] = $lastCommand;
        } else
        {
            echo "No commands to undo.<br />";
        }
    }

    public function redoLastUndoneCommand()
    {
        if (!empty($this->undoneCommands))
        {
            $lastUndoneCommand = array_pop($this->undoneCommands);
            $lastUndoneCommand->execute();
            $this->commands[] = $lastUndoneCommand;
        } else
        {
            echo "No commands to redo.<br />";
        }
    }
}