<?php
class passwordInvalid
{
    /**
    * Function to validate and filter sensitive input data, such as passwords.
    *
    * @param string $input The input data to be validated and filtered.
    * @return string|null Returns the filtered input data or NULL if invalid.
    */
    public static function validateSensitiveInput($input)
    {
        // Minimum length required for the input data
        $minLength = 8;

        // Maximum length allowed for the input data
        $maxLength = 20;

        // Check if the input data meets the length requirements
        $inputLength = strlen($input);
        if ($inputLength < $minLength || $inputLength > $maxLength)
        {
            // Input data does not meet length requirements
            return null;
        }

        // Apply filtering to prevent injection attacks
        $filteredInput = htmlspecialchars($input, ENT_QUOTES, 'UTF-8');

        // If the input passes all validations, return the filtered input
        return $filteredInput;
    }
}